<?php
require __DIR__.'/../../idrbusinessconsultancy/vendor/autoload.php';

$dotenv = Dotenv\Dotenv::createImmutable(__DIR__.'/../../idrbusinessconsultancy');
$dotenv->load();

echo "Testing database connection...<br><br>";
echo "DB_HOST: " . $_ENV['DB_HOST'] . "<br>";
echo "DB_DATABASE: " . $_ENV['DB_DATABASE'] . "<br>";
echo "DB_USERNAME: " . $_ENV['DB_USERNAME'] . "<br>";
echo "DB_PASSWORD: " . (isset($_ENV['DB_PASSWORD']) ? str_repeat('*', strlen($_ENV['DB_PASSWORD'])) : 'NOT SET') . "<br><br>";

try {
    $pdo = new PDO(
        "mysql:host={$_ENV['DB_HOST']};dbname={$_ENV['DB_DATABASE']}",
        $_ENV['DB_USERNAME'],
        $_ENV['DB_PASSWORD']
    );
    echo "✅ Database connection successful!";
} catch (PDOException $e) {
    echo "❌ Connection failed: " . $e->getMessage();
}
?>